#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../common/cancel_appointment'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../helper/modal'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../module/database/OracleUtility'

describe '[Story# VAR-1922: Booked Appointment - Detailed View ]
          [Story# VAR-3614: Appointment Details - Add Facility Name]
          [Story# VAR-2661: Appointment Details - Export to Electronic Calendar]
          [Story# VAR-4282: Disable cancel appointment button for 10/20 min slots, variable length appointments, and odd start times]
          [Task# VAR-7402: Remove block on canceling 10/20 and Variable appointments]
          [Story#VAR-11746: Display Clinic Location friendly name in Appointment List]' do
  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @db = connectToMongoDB("var-utility")

    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y @ 0900")
    @twoDaysLater = getDateNthDaysFromNow(2, "%m/%d/%Y @ 0900")
    @thirtyDaysLater = getDateNthDaysFromNow(30, "%m/%d/%Y @ 0900")
    @thirtyOneDaysLater = getDateNthDaysFromNow(31, "%m/%d/%Y @ 0900")
    @sevenDaysLater = getDateNthDaysFromNow(7, "%m/%d/%Y")
    @@timeSlot = "11:00"
    @@all_appointments_dates = '';
    @friendly_name = "Facility Friendly Text"
    @clinic_friendly_name ="JP PRIMARY CARE DR. CREAMER"
    @location = "BOSTON HCS VAMC"
    @clinic = PRIMARY_CARE.upcase.strip
    #cancel existing appointment
    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@sevenDaysLater} 11:00:00")
    @cancel_appointment.cancel_appointment()
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    deletePatientData("1113138327")
    @common.loginEndsOnHome(pw_redacted)
    @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)

  end

  after(:all) do

    @driver.close
  end

  context 'AC#VAR-2048|TC#VAR-2230: Booked Appointment - Detail view
           AC#VAR-3707|TC#VAR-3708:  Add Facility Name Criteria
           AC#VAR-3711|TC#VAR-3712: Test Export to Electornic Calendar
           AC#VAR-11910|TC#VAR11911: Display Clinic Location friendly name in Appointment List' do

    it "Should verify Booked appointment Table sorted by date" do
      @common.selectAddAppointmentButton("VA")
      @new_appointment.createAppointment(PRIMARY_CARE, '523', '32', 'test', @sevenDaysLater, @@timeSlot, 'testAutomation@testAutomationxyz.com')
      @@setDate = NewAppointmentRequest.bookedDate
      @@selectedSlot = @@setDate
      button_element = @driver.button(:id => 'back-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @landing_appointments.refresh
      @common.waitWhileSpinnerPresent
      sleep 2
      @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing_appointments.appointment_table_list_elements.length >= 1}
      @@all_appointments_dates = @landing_appointments.list_of_appointment_dates_elements
      expect(@landing_appointments.areColumnsSorted?(@@all_appointments_dates)).to eq(true)
    end

    it 'Should Verify clinic friendly name and details for recently booked appointment in list' do

      @@selectedDay = getDayofWeek(@@selectedSlot)
      @@timeSlot = @@timeSlot.gsub!(':', '')
      all_appointments = @landing_appointments.list_of_appointments_elements
      appointment_to_verify = "View details for your appointment," + "\n" + "Date/Time:" + "\n" + "#{@@selectedDay}," + " #{@@setDate}" + "\n" + "#{@@timeSlot}" + "\n" + "#{@@selectedDay}, #{@@setDate} #{@@timeSlot.gsub("", " ")}" + "\n" + "Details:" + "\n" + "VA Facility Appointment" + "\n" +"#{@location}" + "\n" + "#{@clinic_friendly_name}" + "\n" + "Also called: #{@clinic}" + "\n" + "Prepare/Join:" + "\n" +"Prepare for your appointment"
      expect(@landing_appointments.verifyAppointmentDetailsInList(all_appointments, appointment_to_verify)).to eq(true)
    end

    it 'Should verify Appointment is displayed in list after app refresh' do
      @landing_appointments.clickRefresh
      @common.waitWhileSpinnerPresent
      sleep 2
      @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing_appointments.appointment_table_list_elements.length >= 1}
      all_appointments = @landing_appointments.list_of_appointments_elements
      appointment_to_verify = "View details for your appointment," + "\n" + "Date/Time:" + "\n" + "#{@@selectedDay}," + " #{@@setDate}" + "\n" + "#{@@timeSlot}" + "\n" + "#{@@selectedDay}, #{@@setDate} #{@@timeSlot.gsub("", " ")}" + "\n" + "Details:" + "\n" + "VA Facility Appointment" + "\n" +"#{@location}" + "\n" + "#{@clinic_friendly_name}" + "\n" + "Also called: #{@clinic}" + "\n" + "Prepare/Join:" + "\n" +"Prepare for your appointment"
      expect(@landing_appointments.verifyAppointmentDetailsInList(all_appointments, appointment_to_verify)).to eq(true)

    end

    it "Should Verify Detail screen for booked appointment" do
      all_appointments = @landing_appointments.list_of_appointments_elements
      appointment_to_select = "View details for your appointment," + "\n" + "Date/Time:" + "\n" + "#{@@selectedDay}," + " #{@@setDate}" + "\n" + "#{@@timeSlot}" + "\n" + "#{@@selectedDay}, #{@@setDate} #{@@timeSlot.gsub("", " ")}" + "\n" + "Details:" + "\n" + "VA Facility Appointment" + "\n" +"#{@location}" + "\n" + "#{@clinic_friendly_name}" + "\n" + "Also called: #{@clinic}" + "\n" + "Prepare/Join:" + "\n" +"Prepare for your appointment"
      @landing_appointments.openIfAppointmentExists(all_appointments, appointment_to_select)
      @common.waitWhileSpinnerPresent
      expected_text = [\
          "Date and Time:" + " #{@@selectedDay}," + " #{@@setDate}",
          "Date:" + " #{@@selectedDay},"+ " #{@@setDate}",
          @@timeSlot,
          "Time: #{@@timeSlot.gsub("", " ")}",
          "Add to Calendar",
          "Details: " + "#{@location}",
          "#{@clinic_friendly_name}",
          "Also called: #{@clinic}",
          "Please arrive 30 minutes before your scheduled time unless otherwise directed. VA Facility Locator",
          "Cancel Appointment",
          "Reason for Appointment: test"
      ]
      @detail.appointment_details_group_element.when_present(TIME_OUT_LIMIT)
      actual_text = @detail.appointment_details_group_element.text.split("\n")
      actual_text = actual_text.reject { |c| c.empty? }
      expected_text.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i].gsub(/\s+/, '')).to eq(expectedScreenRow.gsub(/\s+/, ''))
      end

    end

    it "Should verify details on Back icon (<): shown left justified on the subheader bar, left justified" do
      expect(@detail.back_btn_element.exists?).to eq(true)
      expect(@detail.back_btn_element.attribute("class")).to include("ui-btn-left")
      expect(@detail.back_label).to eq("Appointments/Requests")
      expect(@detail.back_btn_element.visible?).to eq(true)
      expect(@detail.back_btn_element.attribute("aria-label")).to eq("Return to Appointments and Requests")

    end


    it "Should verify Calendar export icon and link Text 'Add to Calendar'" do
      expect(@detail.add_to_calendar_element.visible?).to eq(true)
      expect(@detail.calendar_icon_element.visible?).to eq(true)
      expect(@detail.add_to_calendar_element.text.strip).to eq("Add to Calendar")
    end

  end

  #TODO: DO NOT DELETE. THIS TEST NEEDS TO BE ENABLED WHEN CLINICS WITH Mentioned slots are available
=begin
  context "AC#VAR-4307|TC#4308: Disable appt cancel for appts booked at clinics with 10/20 min slot and variable appt length" do
      it "Display text message 'If you need to cancel this appointment, please contact the facility directly.' instead of cancel button" do
        @detail.back_btn

        #mock data
        Watir::Wait.until {@landing_appointments.appointment_table_list_elements.length >=  1}
        resizeWindowToDefault
        @common.logoutAndLogbackWithADifferentUser(pw_redacted)

        @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)

        Watir::Wait.until {@landing_appointments.appointment_table_list_elements.length == 4}
        expect(@landing_appointments.appointment_table_list_elements.length).to eq(4)
        @common.waitWhileSpinnerPresent()

        #scenarios
        #1. 3 * 10 min slots (variable length) - can cancel
        #2. 1 * 10 min slot - can cancel
        #3  1 * 20 min slot - can cancel
        #4  30 min slot & odd time start 10:15:00

        for i in 0...4
          @landing_appointments.appointment_table_list_elements[i].click
          @common.waitWhileSpinnerPresent

          @detail.appointment_details_group_element.when_present(TIME_OUT_LIMIT)
          expect(@detail.has_expected_title?).to eq(true)

          #cancel is disabled only for Odd Start Time
          if i == 3 then
            expect(@detail.cancel_by_contacting_facility_message_element.text).to eq('If you need to cancel this appointment, please contact the facility directly.')
          else

            expected_text = [\
                              "I need to cancel this appointment",
                              "Yes", "No"
                            ]

            actual_text = @detail.cancel_reason_section_element.text.split("\n")

            expected_text.each_with_index do | expectedScreenRow, i |
              expect(actual_text[i]).to eq(expectedScreenRow)
            end

          end


          @detail.back_btn
          @common.waitWhileSpinnerPresent

          Watir::Wait.until {@landing_appointments.appointment_table_list_elements.length == 4}
          @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)

        end
      end
  end
=end
end









